package com.tomas.ht_ydt.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;


import com.tomas.ht_ydt.ListData.LabelItem_list;
import com.tomas.ht_ydt.R;

import java.text.DecimalFormat;
import java.util.List;

public class StocktakingLabel_Adapter extends RecyclerView.Adapter<StocktakingLabel_Adapter.ViewHolder> {
    private List<LabelItem_list> data;
    Context context;
    DecimalFormat decimalFormat;
    public StocktakingLabel_Adapter(List<LabelItem_list> dataset, Context context) {
        data = dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        LinearLayout layout;
        TextView txt_no, txt_part, txt_lot_no, txt_box_no, txt_qty, txt_status;
        public ViewHolder(View itemview){
            super(itemview);
            layout = (LinearLayout) itemview.findViewById(R.id.item_row);
            txt_no = (TextView)itemView.findViewById(R.id.txt_no);
            txt_part = (TextView)itemView.findViewById(R.id.txt_part);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_box_no = (TextView)itemView.findViewById(R.id.txt_box_no);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
            txt_status = (TextView)itemView.findViewById(R.id.txt_status);
        }
    }


    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_stocktaking_label,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,##0");
        final LabelItem_list item = data.get(position);
        holder.txt_no.setText(item.getNo());
        holder.txt_part.setText(item.getLbl_part_no());
        holder.txt_lot_no.setText(item.getLot_no());
        holder.txt_box_no.setText(item.getSerial_no());
        holder.txt_qty.setText(decimalFormat.format(Double.parseDouble(item.getIssue_qty())));
        holder.txt_status.setText(item.getStatus());

        String status = item.getStatus();
        if (status.trim().equals("OK")){
           holder.txt_status.setBackgroundResource(R.color.green);
        }else if (status.trim().equals("NG")){
            holder.txt_status.setBackgroundResource(R.color.red);
        } else {
            holder.layout.setBackgroundResource(R.drawable.background_row);
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
